<?php require_once "/var/www/html/config.database.php"; ?>
<?php
/**
 * ==========================================================
 * FX-HUNTER — MASTER LICENSE SYNC ENGINE (FINAL STABLE)
 * ==========================================================
 */

require_once __DIR__ . '/../portal/config.php';
require_once __DIR__ . '/../portal/helpers/decrypt_license.php';

$log = __DIR__ . "/sync_log.txt";
file_put_contents($log,"\n----- RUN ".date("Y-m-d H:i:s")." -----\n",FILE_APPEND);


/*-----------------------------------------------------------
  1. LOAD MASTER LICENSE SOURCE (LMFWC)
-----------------------------------------------------------*/

$lm = [];

$res = $conn->query("
    SELECT license_key, expires_at, status
    FROM fxhai_lmfwc_licenses
");

while($r = $res->fetch_assoc())
{
    $plain = fxh_decrypt_license($r['license_key']);

    if(!$plain) continue;

    $clean = preg_replace('/[^0-9A-Za-z]/','',$plain);

    // ✅ Normalise multi-status LMFWC values
    $status = strtolower(trim($r['status']));

    $isActive = (
        $status == 'active' ||
        $status == 'completed' ||
        $status == 'valid' ||
        $status == 'active_subscription'
    );

    $lm[$clean] = [
        'expires' => $r['expires_at'],
        'active'  => $isActive ? 1 : 0
    ];
}

file_put_contents($log,"LMFWC IMPORT: ".count($lm)." licenses\n",FILE_APPEND);


/*-----------------------------------------------------------
  2. LOAD FXH CACHE
-----------------------------------------------------------*/

$fxh = [];

$res = $conn->query("SELECT license_key FROM fxh_licenses");

while($r = $res->fetch_assoc()){
    $fxh[$r['license_key']] = true;
}


/*-----------------------------------------------------------
  3. INSERT MISSING LICENSES
-----------------------------------------------------------*/

foreach($lm as $key=>$data){

    if(!isset($fxh[$key])){

        $stmt = $conn->prepare("
            INSERT INTO fxh_licenses
              (license_key, expires_at, active)
            VALUES (?,?,?)
        ");

        $stmt->bind_param("ssi",$key,$data['expires'],$data['active']);
        $stmt->execute();

        file_put_contents($log,"INSERT: $key\n",FILE_APPEND);
    }
}


/*-----------------------------------------------------------
  4. UPDATE EXISTING LICENSES
-----------------------------------------------------------*/

foreach($lm as $key=>$data){

    $stmt = $conn->prepare("
        UPDATE fxh_licenses
        SET expires_at=?, active=?
        WHERE license_key=?
    ");

    $stmt->bind_param("sis",$data['expires'],$data['active'],$key);
    $stmt->execute();
}


/*-----------------------------------------------------------
  5. DELETE ORPHAN LICENSES
-----------------------------------------------------------*/

foreach($fxh as $key=>$_){

    if(!isset($lm[$key])){

        $stmt = $conn->prepare("
            DELETE FROM fxh_licenses
            WHERE license_key=?
        ");

        $stmt->bind_param("s",$key);
        $stmt->execute();

        file_put_contents($log,"DELETE: $key\n",FILE_APPEND);
    }
}

echo "SYNC OK";
