<?php require_once "/var/www/html/config.database.php"; ?>
<?php
/**
 * FXHunterAI — LICENSE FILE SYNC ENGINE (FINAL V3)
 * Auto-creates missing files
 * Auto-deletes orphan files
 * Uses REAL columns from fxh_licenses table
 * 100% prevents HTTP 500 errors
 */

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

header("Content-Type: text/plain; charset=utf-8");

// ----------------------------------------------------------
// 1. Connect to DATABASE (your REAL credentials)
// ----------------------------------------------------------
$DB_HOST = FXH_DB_HOST;
$DB_USER = FXH_DB_USER;
$DB_PASS = FXH_DB_PASS;
$DB_NAME = FXH_DB_NAME;

$conn = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME);

if ($conn->connect_error) {
    die("DB ERROR: " . $conn->connect_error);
}


// ----------------------------------------------------------
// 2. Read ACTIVE licenses (correct column = active)
// ----------------------------------------------------------
// active = 1 means Valid license
// NO COLUMN NAMED “status” (your 500 error source)

$sql = "
    SELECT license_key
    FROM fxh_licenses
    WHERE active = 1
";

$q = $conn->query($sql);

if (!$q) {
    die("SQL ERROR: " . $conn->error . "\nQUERY: " . $sql);
}

$db_keys = [];
while ($row = $q->fetch_assoc()) {
    $key = trim($row["license_key"]);
    if ($key !== "") {
        $db_keys[] = $key;
    }
}

sort($db_keys);


// ----------------------------------------------------------
// 3. Scan existing signal files
// ----------------------------------------------------------
$dir = __DIR__ . "/signals";

if (!is_dir($dir)) {
    mkdir($dir, 0755, true);
}

$files = glob($dir . "/latest_signal_*.txt");

$folder_keys = [];
foreach ($files as $f) {
    $name = basename($f);
    $key = str_replace(["latest_signal_", ".txt"], "", $name);
    $folder_keys[] = $key;
}

sort($folder_keys);


// ----------------------------------------------------------
// 4. Create missing files
// ----------------------------------------------------------
$created = 0;

foreach ($db_keys as $key) {
    $filepath = $dir . "/latest_signal_" . $key . ".txt";

    if (!file_exists($filepath)) {
        file_put_contents(
            $filepath,
            "INITIAL|" . gmdate("Y-m-d H:i:s") . "\n",
            LOCK_EX
        );
        $created++;
    }
}


// ----------------------------------------------------------
// 5. Delete orphan files
// ----------------------------------------------------------
$deleted = 0;

foreach ($folder_keys as $key) {
    if (!in_array($key, $db_keys)) {
        $filepath = $dir . "/latest_signal_" . $key . ".txt";
        unlink($filepath);
        $deleted++;
    }
}


// ----------------------------------------------------------
// 6. Output clean result (TEXT MODE)
// ----------------------------------------------------------
echo "=== FXHUNTER LICENSE SYNC DONE ===\n";
echo "DB Licenses:   " . count($db_keys) . "\n";
echo "Files Found:   " . count($folder_keys) . "\n";
echo "Files Created: $created\n";
echo "Files Deleted: $deleted\n";
echo "Timestamp:     " . date("Y-m-d H:i:s") . "\n";
