<?php
/* ==================================================
   FX-HUNTER — STORE TRADE LOG + AI FEEDBACK + EXIT QUALITY
   FINAL / VERIFIED / ERROR-FREE
   ================================================== */

ini_set('display_errors', 1);
error_reporting(E_ALL);

require_once "/var/www/html/config.database.php";
require_once __DIR__ . "/config.php";

header("Content-Type: application/json");

// --------------------------------------------------
// DB CONNECT
// --------------------------------------------------
$db = fxh_db();
if (!$db) {
    echo json_encode(['status' => 'db_error']);
    exit;
}

// --------------------------------------------------
// READ JSON INPUT
// --------------------------------------------------
$raw = file_get_contents("php://input");
$j   = json_decode($raw, true);

if (!$j) {
    echo json_encode(['status' => 'invalid_json']);
    exit;
}

// --------------------------------------------------
// REQUIRED FIELDS
// --------------------------------------------------
$required = [
    'license','account','ticket','symbol','type','volume',
    'open_price','close_price','profit',
    'open_time','close_time','sl','tp','comment'
];

foreach ($required as $f) {
    if (!isset($j[$f])) {
        echo json_encode(['status' => "missing_$f"]);
        exit;
    }
}

// --------------------------------------------------
// NORMALIZE
// --------------------------------------------------
$license = $j['license'];
$account = (int)$j['account'];
$ticket  = (int)$j['ticket'];
$symbol  = strtoupper($j['symbol']);
$type    = strtoupper($j['type']);
$profit  = (float)$j['profit'];

// --------------------------------------------------
// INSERT TRADE LOG  ✅ FIXED
// --------------------------------------------------
$stmt = $db->prepare("
INSERT INTO fxh_trade_logs
(license_key, mt5_account, ticket, symbol, type, volume,
 open_price, close_price, profit,
 open_time, close_time, sl, tp, comment)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?)
");

$stmt->bind_param(
    "siissddddssdds",
    $license,
    $account,
    $ticket,
    $symbol,
    $type,
    $j['volume'],
    $j['open_price'],
    $j['close_price'],
    $profit,
    $j['open_time'],
    $j['close_time'],
    $j['sl'],
    $j['tp'],
    $j['comment']
);

$stmt->execute();

// --------------------------------------------------
// TIMEFRAME
// --------------------------------------------------
$tf = 0;
if (preg_match('/\b(M1|M3|M5|M15|M30)\b/i', $j['comment'], $m)) {
    $tf = (int)substr($m[1],1);
}

// --------------------------------------------------
// AI CONFIDENCE
// --------------------------------------------------
$won    = ($profit > 0 ? 1 : 0);
$trades = 1;

$stmt = $db->prepare("
INSERT INTO fxh_ai_confidence
(license_key, symbol, timeframe, trades, wins, confidence)
VALUES (?,?,?,?,?,50)
ON DUPLICATE KEY UPDATE
 trades = trades + 1,
 wins   = wins + VALUES(wins),
 confidence =
   LEAST(100,
     GREATEST(10,
       confidence + IF(?,3,-4)
     )
   )
");

$stmt->bind_param(
    "ssiiii",
    $license,
    $symbol,
    $tf,
    $trades,
    $won,
    $won
);

$stmt->execute();

// --------------------------------------------------
// EXIT QUALITY (PHASE-12)
// --------------------------------------------------
$direction = ($type === 'BUY') ? 1 : -1;
$exitScore = ($profit > 0 ? 70 : ($profit < 0 ? 30 : 50));

$strategy_id = 'DEFAULT';
if (strpos($j['comment'], '|') !== false) {
    $strategy_id = substr($j['comment'], 0, 64);
}

$stmt = $db->prepare("
INSERT INTO fxh_exit_quality
(license_key, mt5_account, ticket, symbol, direction,
 profit, exit_score, timeframe, strategy_id)
VALUES (?,?,?,?,?,?,?,?,?)
");

$stmt->bind_param(
    "siisidiis",
    $license,
    $account,
    $ticket,
    $symbol,
    $direction,
    $profit,
    $exitScore,
    $tf,
    $strategy_id
);

$stmt->execute();

// --------------------------------------------------
// DONE
// --------------------------------------------------
echo json_encode(['status'=>'ok']);
