<?php require_once "/var/www/html/config.database.php"; ?>
<?php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json');

$db = fxh_db();
if(!$db){ echo json_encode(['status'=>'error']); exit; }

$raw = file_get_contents("php://input");
$j = json_decode($raw, true);
if(!$j){ echo json_encode(['status'=>'error']); exit; }

$license = $j['license'] ?? '';
if($license==''){ echo json_encode(['status'=>'error']); exit; }

$stmt = $db->prepare("
INSERT INTO fxh_positions_live
(license_key, mt5_account, ticket, symbol, type, volume,
 open_price, sl, tp, profit, swap, commission, open_time, updated_at)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,NOW())
ON DUPLICATE KEY UPDATE
  volume=VALUES(volume),
  sl=VALUES(sl),
  tp=VALUES(tp),
  profit=VALUES(profit),
  swap=VALUES(swap),
  commission=VALUES(commission),
  updated_at=NOW()
");

$stmt->bind_param(
    "siissdddsssds",
    $license,
    $j['account'],
    $j['ticket'],
    $j['symbol'],
    $j['type'],
    $j['volume'],
    $j['open_price'],
    $j['sl'],
    $j['tp'],
    $j['profit'],
    $j['swap'],
    $j['commission'],
    $j['open_time']
);

$stmt->execute();

echo json_encode(['status'=>'ok']);
?>
