<?php
require_once "/var/www/html/config.database.php";

/**
 * FXHunterAI Save Signal — FINAL V9
 * ✔ Single license
 * ✔ Multi-license
 * ✔ Per-license risk override (Option A)
 * ✔ No EA changes
 * ✔ No DB changes
 */

header('Content-Type: application/json; charset=utf-8');
header('Cache-Control: no-store, no-cache, must-revalidate');

// ------------------------------------------------
// SIGNAL DIRECTORY
// ------------------------------------------------
$dir = __DIR__ . '/signals';
if (!is_dir($dir)) {
    mkdir($dir, 0777, true);
    chmod($dir, 0777);
}

// ------------------------------------------------
// READ RAW INPUT
// ------------------------------------------------
$raw = file_get_contents("php://input");

if (!empty($raw)) {
    $j = json_decode($raw, true);
    if (is_array($j)) {
        if (isset($j['signal']))  $raw = $j['signal'];
        elseif (isset($j['msg'])) $raw = $j['msg'];
        else                      $raw = implode(",", $j);
    }
}

if (empty($raw)) {
    $raw = $_POST["signal"] ?? $_GET["signal"] ?? "";
}

$signal = trim($raw);
if ($signal === "") {
    echo json_encode(["status"=>"error","message"=>"No signal"]);
    exit;
}

// ------------------------------------------------
// SPLIT CSV
// ------------------------------------------------
$parts = array_map('trim', explode(",", $signal));
$licenseField = $parts[0] ?? "";

// ------------------------------------------------
// EXTRACT BASE PARAMS (risk, sl, tp, etc.)
// ------------------------------------------------
$baseParams = [];
for ($i = 3; $i < count($parts); $i++) {
    if (strpos($parts[$i], "=") !== false) {
        [$k, $v] = explode("=", $parts[$i], 2);
        $baseParams[strtolower(trim($k))] = trim($v);
    }
}

// ------------------------------------------------
// PARSE LICENSE LIST (with inline overrides)
// ------------------------------------------------
$licenseItems = [];
if (strpos($licenseField, "|") !== false) {
    $licenseItems = array_filter(array_map('trim', explode("|", $licenseField)));
} else {
    $licenseItems[] = $licenseField;
}

// ------------------------------------------------
// BUILD + WRITE FILE PER LICENSE
// ------------------------------------------------
$count = 0;

foreach ($licenseItems as $item) {

    if ($item === "") continue;

    // --------------------------------------------
    // Parse license + inline overrides
    // --------------------------------------------
    $license = $item;
    $overrides = [];

    if (strpos($item, ":") !== false) {
        [$license, $ovr] = explode(":", $item, 2);
        $pairs = explode(";", $ovr);
        foreach ($pairs as $p) {
            if (strpos($p, "=") !== false) {
                [$k, $v] = explode("=", $p, 2);
                $overrides[strtolower(trim($k))] = trim($v);
            }
        }
    }

    $license = trim($license);
    if ($license === "") continue;

    // --------------------------------------------
    // Merge params (override > base)
    // --------------------------------------------
    $finalParams = $baseParams;
    foreach ($overrides as $k => $v) {
        $finalParams[$k] = $v;
    }

    // --------------------------------------------
    // Rebuild signal line
    // --------------------------------------------
    $outParts = [];
    $outParts[] = $license;
    $outParts[] = $parts[1] ?? "";
    $outParts[] = $parts[2] ?? "";

    foreach ($finalParams as $k => $v) {
        $outParts[] = $k . "=" . $v;
    }

    $entry = implode(",", $outParts) . "|" . gmdate("Y-m-d H:i:s") . PHP_EOL;

    // --------------------------------------------
    // Write file
    // --------------------------------------------
    $clean = preg_replace('/[^0-9A-Za-z_-]/', '', $license);
    $path  = $dir . "/latest_signal_" . $clean . ".txt";
    file_put_contents($path, $entry, LOCK_EX);
    chmod($path, 0666);

    $count++;
}

// ------------------------------------------------
// GLOBAL LOG (first license only, unchanged)
// ------------------------------------------------
if ($count > 0) {
    file_put_contents($dir . "/latest_signal.txt", $entry, LOCK_EX);
}

// ------------------------------------------------
// RESPONSE
// ------------------------------------------------
echo json_encode([
    "status"  => "ok",
    "mode"    => ($count > 1 ? "multi-license" : "single-license"),
    "targets" => $count
]);
exit;
