<?php
ini_set('display_errors',0);
error_reporting(0);

require_once __DIR__."/../portal/config.php";

$license = $_GET['license'] ?? '';
$mt5     = $_GET['mt5'] ?? '';

if($license==='' || $mt5===''){
    exit("NONE");
}

/* Fetch first QUEUED command */
$q = $conn->prepare("
    SELECT id, action 
    FROM fxh_trade_commands
    WHERE license_key=?
      AND mt5_account=?
      AND status='QUEUED'
    ORDER BY id ASC
    LIMIT 1
");

$q->bind_param("ss",$license,$mt5);
$q->execute();
$res = $q->get_result();

$row=$res->fetch_assoc();

if(!$row){
    exit("NONE");
}

/* Mark EXECUTED immediately */
$upd=$conn->prepare("UPDATE fxh_trade_commands SET status='EXECUTED' WHERE id=?");
$upd->bind_param("i",$row['id']);
$upd->execute();

/* Translate to RAW EA commands */
$action = strtoupper($row['action']);

switch($action){

    case "CLOSE_FULL":
    case "BOOK_PROFIT":
         echo "BOOK_PROFIT";
         exit;

    default:
         echo "NONE";
         exit;
}
