<?php
define("FXH_PORTAL", true);
$pageTitle = "Plans";

require_once __DIR__.'/../config.php';
require_once __DIR__.'/../config.nowpayments.php';
require_once __DIR__.'/middleware/user_auth.php';
require_once __DIR__.'/includes/header.php';
require_once __DIR__.'/includes/sidebar.php';
?>

<style>
.fxh-plan-grid{
    display:grid;
    grid-template-columns: repeat(auto-fit,minmax(260px,1fr));
    gap:30px;
    margin-top:20px;
}

.fxh-plan-card{
    background:rgba(10,14,22,.92);
    border-radius:18px;
    border:1px solid rgba(0,234,255,.25);
    padding:26px;
    color:#cfeaff;
    text-align:center;
    box-shadow:0 0 22px rgba(0,234,255,.15);
    transition:.25s ease;
}

.fxh-plan-card:hover{
    transform:translateY(-4px);
    box-shadow:0 0 36px rgba(0,234,255,.4);
}

.fxh-plan-card h2{
    color:#00eaff;
    font-size:22px;
}

.fxh-plan-desc{
    opacity:.85;
    margin:10px 0;
}

.fxh-price{
    font-size:26px;
    margin:14px 0;
}

.old{
    text-decoration:line-through;
    opacity:.35;
}

.new{
    color:#00ff9c;
    font-weight:800;
    margin-left:8px;
}

.diamond .new{
    color:#ffd15c;
}

.fxh-buy-btn{
    background:linear-gradient(90deg,#00eaff,#7a35ff);
    border:none;
    border-radius:14px;
    padding:12px 26px;
    color:white;
    font-weight:700;
    cursor:pointer;
    width:100%;
    box-shadow:0 0 18px rgba(0,234,255,.35);
}

.fxh-buy-btn:hover{
    box-shadow:0 0 28px rgba(0,234,255,.65);
}

.diamond{
    border-color:#ffd15c;
}
</style>

<div class="fxh-main">

<h1 class="fx-rotator-title">
Choose Your <span>Plan</span>
</h1>

<div class="fxh-plan-grid">

<div class="fxh-plan-card">
<h2>BRONZE</h2>
<p class="fxh-plan-desc">1 Terminal | Monthly</p>
<div class="fxh-price">
<span class="old">$40</span>
<span class="new">$20</span>/mo
</div>
<button class="fxh-buy-btn" data-plan="BRONZE">BUY BRONZE</button>
</div>

<div class="fxh-plan-card">
<h2>SILVER</h2>
<p class="fxh-plan-desc">3 Terminals | Monthly</p>
<div class="fxh-price">
<span class="old">$70</span>
<span class="new">$30</span>/mo
</div>
<button class="fxh-buy-btn" data-plan="SILVER">BUY SILVER</button>
</div>

<div class="fxh-plan-card">
<h2>GOLD</h2>
<p class="fxh-plan-desc">10 Terminals | Yearly</p>
<div class="fxh-price">
<span class="old">$150</span>
<span class="new">$90</span>/yr
</div>
<button class="fxh-buy-btn" data-plan="GOLD">BUY GOLD</button>
</div>

<div class="fxh-plan-card diamond">
<h2>DIAMOND</h2>
<p class="fxh-plan-desc">10 Terminals | Lifetime</p>
<div class="fxh-price">
<span class="old">$2000</span>
<span class="new">$999</span>
</div>
<button class="fxh-buy-btn" data-plan="DIAMOND">BUY DIAMOND</button>
</div>

</div>
</div>

<script>
document.querySelectorAll(".fxh-buy-btn").forEach(btn=>{
    btn.addEventListener("click", ()=>{
        const plan = btn.dataset.plan;
        window.location.href = "/portal/checkout.php?plan=" + encodeURIComponent(plan);
    });
});
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>
