<?php 
require_once "config.php";
require_once "auth_check.php";

$page = "connections";
?>
<?php include "header.php"; ?>

<div class="container mt-4">
    <h3 class="mb-3">🔗 MT5 Connections</h3>

    <table class="table table-bordered table-striped">
        <thead>
            <tr>
                <th>Terminal ID</th>
                <th>Account Number</th>
                <th>Symbol</th>
                <th>Last Heartbeat</th>
                <th>Status</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody id="connTable"></tbody>
    </table>
</div>

<script>
function loadConnections() {
    fetch("api/get_connections.php")
    .then(r => r.json())
    .then(data => {
        let html = "";
        data.forEach(row => {
            html += `
            <tr>
                <td>${row.terminal_id}</td>
                <td>${row.account_no}</td>
                <td>${row.default_symbol}</td>
                <td>${row.last_heartbeat}</td>
                <td>${row.status}</td>
                <td><button class='btn btn-danger btn-sm' onclick='delConn("${row.terminal_id}")'>Delete</button></td>
            </tr>`;
        });
        document.getElementById("connTable").innerHTML = html;
    });
}

function delConn(id){
    if(!confirm("Remove this terminal?")) return;
    fetch("api/delete_connection.php?id=" + id)
    .then(() => loadConnections());
}

loadConnections();
</script>

<?php include "footer.php"; ?>
