<?php
ini_set("display_errors", 1);
ini_set("display_startup_errors", 1);
error_reporting(E_ALL);

/* ==========================================================
   FXHUNTER PORTAL — CLEAN + STABLE CONFIG (FINAL)
   IPv4 MySQL Fix + Defuse Decrypt + Password Verify
   ========================================================== */

// ---------------------------------------------
// ERROR DISPLAY (DEBUG SAFE)
// ---------------------------------------------
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// ---------------------------------------------
// START SESSION
// ---------------------------------------------
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// ---------------------------------------------
// DATABASE (FORCE IPv4)
// ---------------------------------------------
require_once "/var/www/html/config.database.php";
$host = FXH_DB_HOST;  // Direct IPv4
$user = FXH_DB_USER;
$pass = FXH_DB_PASS;
$dbname = FXH_DB_NAME;

// IPv4-only mysqli connect
$conn = mysqli_connect($host, $user, $pass, $dbname);

if (!$conn) {
    die("❌ MYSQL CONNECT ERROR: " . mysqli_connect_error());
}

/* =====================================================
   LICENSE KEY GENERATOR — 16 DIGIT NUMERIC ONLY
===================================================== */

function fxh_generate_license_key()
{
    $key = '';

    // Generate exactly 16 digits
    for ($i = 0; $i < 16; $i++) {
        $key .= random_int(0, 9);
    }

    return $key;
}

// ---------------------------------------------
// DEFUSE AUTOLOADER
// ---------------------------------------------
require_once __DIR__ . "/vendor/autoload.php";

use Defuse\Crypto\Key;
use Defuse\Crypto\Crypto;

// ---------------------------------------------
// DEFUSE KEY LOADING
// ---------------------------------------------
$defuse_file = __DIR__ . "/keys/defuse.txt";

if (!file_exists($defuse_file)) {
    die("❌ Defuse key missing at: $defuse_file");
}

try {
    $fxh_key = Key::loadFromAsciiSafeString(
        trim(file_get_contents($defuse_file))
    );
} catch (Throwable $e) {
    die("❌ Failed to load defuse key: " . $e->getMessage());
}

// ---------------------------------------------
// THE REAL, CORRECT, WORKING DECRYPT FUNCTION
// (YOUR ORIGINAL EXACT VERSION)
// ---------------------------------------------
function fxh_decrypt_license($cipher)
{
    global $fxh_key;

    if (!$cipher) return '';
    if (strpos($cipher, 'def5020') !== 0)
        return $cipher;   // Not encrypted → return raw

    try {
        return trim(Crypto::decrypt($cipher, $fxh_key));
    } catch (Throwable $e) {
        return '[decrypt error]';
    }
}

if(!isset($_SESSION['flash'])) {
    $_SESSION['flash'] = [];
}

function fxh_set_flash($msg, $type="error") {
    $_SESSION['flash'] = [
        "msg" => $msg,
        "type" => $type
    ];
}

function fxh_get_flash() {
    if(!empty($_SESSION['flash'])){
        $f = $_SESSION['flash'];
        unset($_SESSION['flash']);
        return $f;
    }
    return null;
}


// ---------------------------------------------
// PASSWORD VERIFIER (WordPress/WooCommerce SAFE)
// ---------------------------------------------
require_once __DIR__ . "/password_verify_fxh.php";

// ---------------------------------------------
// LOGIN CHECKER
// ---------------------------------------------
function requireLogin()
{
    if (!isset($_SESSION['user_id'])) {
        header("Location: /portal/login.php");
        exit;
    }
}

