<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once "/var/www/html/portal/config.php";

header("Content-Type: application/json");

// HARD TEST VALUES (NO JSON YET)
$trade_uuid = bin2hex(random_bytes(8));
$license    = "6773238810197031";

$sql = "
INSERT INTO fxh_trade_queue
(
    trade_uuid,
    license_key,
    action,
    symbol,
    volume,
    sl,
    tp,
    trade_comment,
    created_at
)
VALUES
(
    ?, ?, 'BUY', 'XAUUSD', 0, 1000, 3000, 'PANEL_TEST', NOW()
)
";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    echo json_encode([
        "error" => "PREPARE_FAILED",
        "msg"   => $conn->error
    ]);
    exit;
}

$stmt->bind_param("ss", $trade_uuid, $license);

if (!$stmt->execute()) {
    echo json_encode([
        "error" => "EXECUTE_FAILED",
        "msg"   => $stmt->error
    ]);
    exit;
}

echo json_encode([
    "status"     => "INSERT_OK",
    "trade_uuid" => $trade_uuid
]);
