<?php
/* ============================================================
   FX-HUNTER ACCOUNT RECEIVER — FINAL FIXED VERSION
   ============================================================ */

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

require_once __DIR__ . "/../config.php";


// ============================================================
// READ INPUT
// ============================================================
$raw = file_get_contents("php://input");
$parsed = [];
if ($raw) parse_str($raw, $parsed);

$d = !empty($_POST) ? $_POST : $parsed;

$log  = "---- " . date("Y-m-d H:i:s") . " ----\n";
$log .= "RAW: $raw\n";
$log .= "FINAL:\n" . print_r($d, true) . "\n\n";
file_put_contents(__DIR__."/debug_post_account_raw.txt",$log,FILE_APPEND);

if (empty($d)) exit("NO_DATA");


// ============================================================
// INPUT FIELDS
// ============================================================
$license = $conn->real_escape_string(trim($d['license_key'] ?? ""));
$mt5     = $conn->real_escape_string(trim($d['mt5_account'] ?? ""));

if ($license === '') exit("NO_LICENSE");


// ============================================================
// FIND LICENSE ROW
// ============================================================
$findSQL = "
SELECT id
FROM fxh_licenses
WHERE license_key = '$license'
ORDER BY id ASC
LIMIT 1
";

$res = $conn->query($findSQL);

$debug = "";
$debug .= "FIND_SQL: $findSQL\n";

$license_id = 0;

if ($res && $res->num_rows) {
    $r = $res->fetch_assoc();
    $license_id = (int)$r['id'];
    $debug .= "FOUND ID: $license_id\n";
}
else {
    $debug .= "NOT FOUND\n";
}


// ============================================================
// UPDATE LICENSE WITH MT5 LINK
// ============================================================
if ($license_id > 0 && $mt5 !== '') {

    $updSQL = "
        UPDATE fxh_licenses
        SET mt5_account = '$mt5'
        WHERE id = $license_id
        LIMIT 1
    ";

    $ok = $conn->query($updSQL);

    $debug .= "UPDATE_SQL: $updSQL\n";
    $debug .= "OK: " . ($ok?"YES":"NO") . "\n";
    $debug .= "AFFECTED: ".$conn->affected_rows."\n";

} else {
    $debug .= "SKIPPED UPDATE\n";
}

file_put_contents(__DIR__."/debug_post_account_sql.txt",$debug."\n---------------------\n",FILE_APPEND);


// ============================================================
// METRICS
// ============================================================
$balance     = (float)($d['balance'] ?? 0);
$equity      = (float)($d['equity'] ?? 0);
$profit      = (float)($d['profit'] ?? 0);
$margin      = (float)($d['margin'] ?? 0);
$free_margin = (float)($d['free_margin'] ?? 0);
$margin_lvl  = (float)($d['margin_level'] ?? 0);


// ============================================================
// LOG SNAPSHOT
// ============================================================
$insertSQL = "
INSERT INTO fxh_account_logs
(license_key, mt5_account, balance, equity, profit, margin, free_margin, margin_level)
VALUES
('$license','$mt5','$balance','$equity','$profit','$margin','$free_margin','$margin_lvl')
";

file_put_contents(__DIR__."/debug_post_account_sql.txt","INSERT_SQL: $insertSQL\n\n",FILE_APPEND);
$conn->query($insertSQL);


echo "OK";
