<?php
/*
====================================
  NOWPAYMENTS IPN HANDLER
====================================
*/

require_once __DIR__ . "/../config.php";
require_once __DIR__ . "/../config.nowpayments.php";

/* --------------------------------------------------
   READ RAW INPUT
-------------------------------------------------- */
$raw = file_get_contents("php://input");

if (!$raw) {
    http_response_code(400);
    die("NO DATA");
}

$data = json_decode($raw, true);

if (!$data) {
    http_response_code(400);
    die("INVALID JSON");
}

/* --------------------------------------------------
   VALIDATE SIGNATURE
-------------------------------------------------- */
$signature = $_SERVER['HTTP_X_NOWPAYMENTS_SIG'] ?? '';

$expected = hash_hmac(
    "sha512",
    $raw,
    NOWPAYMENTS_IPN_SECRET
);

if (!hash_equals($expected, $signature)) {
    http_response_code(403);
    die("INVALID SIGNATURE");
}

/* --------------------------------------------------
   READ PAYMENT DATA
-------------------------------------------------- */

$invoiceId  = $data['payment_id'] ?? '';
$orderLabel = $data['order_id']   ?? '';
$status     = strtoupper($data['payment_status'] ?? '');

if (!$invoiceId || !$orderLabel) {
    http_response_code(400);
    die("MISSING DATA");
}

/* --------------------------------------------------
   PROCESS ONLY FINISHED PAYMENTS
-------------------------------------------------- */

if ($status !== "FINISHED") {
    http_response_code(200);
    die("IGNORED");
}

/* --------------------------------------------------
   EXTRACT ORDER ID
-------------------------------------------------- */

if (!preg_match("/FXH-ORDER-(\d+)/", $orderLabel, $m)) {
    http_response_code(400);
    die("INVALID ORDER FORMAT");
}

$order_id = intval($m[1]);

/* --------------------------------------------------
   MARK ORDER PAID
-------------------------------------------------- */

$stmt = $conn->prepare("
    UPDATE fxh_orders
    SET payment_status = 'PAID',
        now_invoice_id = ?
    WHERE id = ?
    LIMIT 1
");

$stmt->bind_param("si", $invoiceId, $order_id);
$stmt->execute();

http_response_code(200);
echo "OK";
