<?php

header("Content-Type: application/json");

require_once __DIR__ . "/../config.php";

$q = $conn->query("
    SELECT *
    FROM fxh_mt5_accounts
    ORDER BY id DESC
    LIMIT 1
");

if(!$q || $q->num_rows == 0)
{
    echo json_encode([
        "account_id"   => "N/A",
        "broker"       => "N/A",
        "balance"      => "0.00",
        "equity"       => "0.00",
        "daily_dd"     => "0.00",
        "max_dd"       => "0.00",
        "open_trades" => "0",
        "status"       => "WAITING_FOR_EA"
    ]);
    exit;
}

$row = $q->fetch_assoc();

echo json_encode([
    "account_id"   => $row["account_id"],
    "broker"       => $row["broker"],
    "balance"      => number_format($row["balance"],2),
    "equity"       => number_format($row["equity"],2),
    "daily_dd"     => number_format($row["daily_dd"],2),
    "max_dd"       => number_format($row["max_dd"],2),
    "open_trades" => $row["open_trades"],
    "status"       => $row["status"]
]);
