<?php
require_once __DIR__ . "/../config.php";

header("Content-Type: application/json");

/*
------------------------------------------------
 FX-HUNTER — DESKTOP LICENSE STATUS
 SOURCE OF TRUTH: fxh_license_activations
 MUST MATCH dashboard.php logic
------------------------------------------------
*/

$q = $conn->query("
    SELECT
        license_key,
        mt5_account,
        last_seen
    FROM fxh_license_activations
");

$now = time();
$list = [];

while ($row = $q->fetch_assoc()) {

    if (!$row['mt5_account'] || !$row['last_seen']) {
        continue;
    }

    $lastTs = strtotime($row['last_seen']);

    // EXACT SAME WINDOW AS DASHBOARD (± buffer)
    $online = ($lastTs >= ($now - 75));

    $list[] = [
        "license_key" => $row['license_key'],
        "mt5_account" => (string)$row['mt5_account'],
        "online"      => $online,
        "last_seen"   => $row['last_seen']
    ];
}

echo json_encode([
    "statuses" => $list
]);
