<?php
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

// ❌ NO headers here
// ❌ NO echo here

$hdr = $_SERVER["HTTP_AUTHORIZATION"] ?? "";

// ✅ accept full token safely
if (!preg_match('/Bearer\s(.+)/', $hdr, $m)) {
    http_response_code(401);
    exit;
}

if (
    empty($_SESSION["fxh_desktop_token"]) ||
    $_SESSION["fxh_desktop_token"] !== $m[1]
) {
    http_response_code(401);
    exit;
}

$userId = $_SESSION["fxh_desktop_user"] ?? 0;

if (!$userId) {
    http_response_code(401);
    exit;
}
