<?php require_once "/var/www/html/config.database.php"; ?>
<?php
require_once "config_webhook.php";

//--------------------------------------------------------
// 1) Verify master webhook token
//--------------------------------------------------------
$headers = getallheaders();
if(!isset($headers['X-FXH-TOKEN'])){
    http_response_code(403);
    echo "TOKEN_MISSING";
    exit;
}

if($headers['X-FXH-TOKEN'] !== $WEBHOOK_MASTER_TOKEN){
    http_response_code(403);
    echo "TOKEN_INVALID";
    exit;
}

//--------------------------------------------------------
// 2) Read raw JSON input
//--------------------------------------------------------
$raw = file_get_contents("php://input");
if(!$raw){
    echo "NO_PAYLOAD";
    exit;
}

// Try decode
$json = json_decode($raw, true);

// Accept both JSON and plain strings
if(is_array($json)){
    $symbol = clean($json["symbol"] ?? "");
    $dir    = clean($json["direction"] ?? "");
    $tf     = clean($json["tf"] ?? "");
    $uid    = clean($json["uid"] ?? "");   // user id
    $price  = clean($json["price"] ?? "");
    $extra  = clean($raw);
}else{
    // fallback mode for raw text alerts
    $symbol = "";
    $dir    = "";
    $tf     = "";
    $uid    = "";
    $price  = "";
    $extra  = clean($raw);
}

//--------------------------------------------------------
// 3) Must include UID (user’s EA token owner)
//--------------------------------------------------------
if($uid == ""){
    echo "NO_UID";
    exit;
}

//--------------------------------------------------------
// 4) Store signal in DB
//--------------------------------------------------------
$ts = date("Y-m-d H:i:s");

$q = $conn->prepare("
    INSERT INTO signals (user_id, symbol, direction, tf, ts, raw)
    VALUES (?, ?, ?, ?, ?, ?)
");
$q->bind_param("isssss", $uid, $symbol, $dir, $tf, $ts, $extra);
$q->execute();

//--------------------------------------------------------
// 5) Write “latest_signal_UID.txt” for EA high-speed polling
//--------------------------------------------------------
$signalFile = __DIR__ . "/signals/latest_signal_" . $uid . ".txt";
file_put_contents($signalFile, $extra);

//--------------------------------------------------------
// 6) Log result
//--------------------------------------------------------
file_put_contents(__DIR__."/webhook.log", 
    "[".$ts."] UID:$uid SYMBOL:$symbol DIR:$dir TF:$tf\n", 
    FILE_APPEND
);

//--------------------------------------------------------
echo "OK";
?>
