<?php require_once "/var/www/html/config.database.php"; ?>
<?php
/**
 * FXHunterAI — Deliver Signal to EA (LICENSE-Based)
 * ------------------------------------------------
 * EA calls:
 *   https://YOUR-SERVER/webhook/deliver_signal.php?license=XXXXXX
 *
 * This returns the latest signal stored in:
 *   /webhook/signals/latest_signal_{LICENSE}.txt
 */

header('Content-Type: text/plain; charset=utf-8');
header('Cache-Control: no-cache, no-store, must-revalidate');

// 1) Read license parameter
$license = $_GET['license'] ?? '';

if ($license == '') {
    echo "";
    exit;
}

// 2) Clean filename
$license = preg_replace('/[^0-9A-Za-z_-]/', '', $license);

// 3) Build path
$file = __DIR__ . "/signals/latest_signal_" . $license . ".txt";

if (!file_exists($file)) {
    echo "";
    exit;
}

// 4) Read last saved signal line
$line = trim(file_get_contents($file));

echo $line;
?>
