<?php require_once "/var/www/html/config.database.php"; ?>
<?php
require_once __DIR__ . '/config.php';
header('Content-Type: application/json');

$db = fxh_db();
if(!$db){ echo json_encode(['status'=>'error','msg'=>'db']); exit; }

$license   = trim($_GET['license'] ?? '');
$account   = intval($_GET['account'] ?? 0);
$broker    = trim($_GET['broker'] ?? '');
$platform  = trim($_GET['platform'] ?? '');
$version   = trim($_GET['ver'] ?? '');
$ip        = $_SERVER['REMOTE_ADDR'];

if($license == '' || $account==0){
    echo json_encode(['status'=>'error','msg'=>'missing']); exit;
}

$stmt = $db->prepare("
    INSERT INTO fxh_connections
    (license_key, mt5_account, broker, platform, version, ip, connected_from, last_seen)
    VALUES (?,?,?,?,?,?,?,NOW())
    ON DUPLICATE KEY UPDATE
      broker=VALUES(broker),
      platform=VALUES(platform),
      version=VALUES(version),
      ip=VALUES(ip),
      connected_from=VALUES(connected_from),
      last_seen=NOW()
");
$from = $broker . ' | ' . $platform;
$stmt->bind_param("sisssss", $license, $account, $broker, $platform, $version, $ip, $from);
$stmt->execute();

echo json_encode(['status'=>'ok','updated'=>true]);
?>
