from pydantic import BaseModel, Field
from typing import List, Optional, Literal

Timeframe = Literal["M1", "M5", "M15", "H1"]

class IndicatorCompare(BaseModel):
    indicator: Literal["ema", "rsi", "atr"]
    period: int

class Condition(BaseModel):
    indicator: Literal["ema", "rsi", "atr"]
    period: int
    op: Literal["cross_above", "cross_below", ">", "<", ">=", "<="]
    value: Optional[float] = None
    compare: Optional[IndicatorCompare] = None

class EntryRules(BaseModel):
    long: List[Condition] = Field(default_factory=list)
    short: List[Condition] = Field(default_factory=list)

class Risk(BaseModel):
    mode: Literal["percent", "fixed"]
    value: float

class Exit(BaseModel):
    sl_points: float
    tp_points: float

class Strategy(BaseModel):
    name: str
    symbol: str
    timeframe: Timeframe
    entry: EntryRules
    risk: Risk
    exit: Exit
