import pandas as pd
import numpy as np

def rsi(series: pd.Series, period: int) -> pd.Series:
    delta = series.diff()
    gain = np.where(delta > 0, delta, 0.0)
    loss = np.where(delta < 0, -delta, 0.0)

    gain_ema = pd.Series(gain, index=series.index).ewm(span=period, adjust=False).mean()
    loss_ema = pd.Series(loss, index=series.index).ewm(span=period, adjust=False).mean()

    rs = gain_ema / loss_ema.replace(0, 1e-10)
    return 100 - (100 / (1 + rs))
