import pandas as pd
from pathlib import Path

REQUIRED_COLS = ["time", "open", "high", "low", "close", "volume"]

def load_candles(base_dir: str, symbol: str, timeframe: str) -> pd.DataFrame:
    path = Path(base_dir) / symbol / f"{timeframe}.csv"
    if not path.exists():
        raise FileNotFoundError(f"Candle file not found: {path}")

    df = pd.read_csv(path)
    missing = [c for c in REQUIRED_COLS if c not in df.columns]
    if missing:
        raise ValueError(f"Missing columns in candles: {missing}")

    df["time"] = pd.to_datetime(df["time"], utc=True)
    df = df.sort_values("time").reset_index(drop=True)
    return df
