import json
import sys
from app.models.strategy import Strategy
from app.engine.candles import load_candles
from app.engine.backtest import backtest

def main():
    if len(sys.argv) < 3:
        print("Usage: python runner.py strategy.json data/candles")
        sys.exit(1)

    strat_path = sys.argv[1]
    candles_dir = sys.argv[2]

    with open(strat_path, "r") as f:
        strategy = Strategy(**json.load(f))

    df = load_candles(candles_dir, strategy.symbol, strategy.timeframe)
    trades = backtest(df, strategy)

    out = f"data/results/{strategy.name}_trades.csv"
    trades.to_csv(out, index=False)
    print(f"Backtest complete → {out}")

if __name__ == "__main__":
    main()
