<?php
require_once '../middleware/user_auth.php';

$user_id = $_SESSION['user_id'];

// ------------------------------
// PAGINATION SETUP
// ------------------------------
$limit = 50; // trades per page
$page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
$offset = ($page - 1) * $limit;

// ------------------------------
// FILTERS
// ------------------------------
$where = "WHERE user_id = '$user_id'";

if(isset($_GET['symbol']) && $_GET['symbol'] !== ""){
    $symbol = $conn->real_escape_string($_GET['symbol']);
    $where .= " AND symbol = '$symbol'";
}

if(isset($_GET['start']) && isset($_GET['end'])){
    if($_GET['start'] !== "" && $_GET['end'] !== ""){
        $start = $_GET['start'];
        $end   = $_GET['end'];
        $where .= " AND DATE(close_time) BETWEEN '$start' AND '$end'";
    }
}

if(isset($_GET['ticket']) && $_GET['ticket'] !== ""){
    $ticket = (int)$_GET['ticket'];
    $where .= " AND ticket = '$ticket'";
}

// ------------------------------
// TOTAL RECORDS FOR PAGINATION
// ------------------------------
$totalRows = $conn->query("
    SELECT COUNT(*) AS total FROM fxh_trade_logs
    $where
")->fetch_assoc()['total'];

$totalPages = ceil($totalRows / $limit);

// ------------------------------
// FETCH TRADES
// ------------------------------
$trades = $conn->query("
    SELECT * FROM fxh_trade_logs
    $where
    ORDER BY id DESC
    LIMIT $limit OFFSET $offset
");
?>
<!DOCTYPE html>
<html>
<head>
<title>My Trades</title>

<style>
body { font-family: Arial; padding:20px; background:#f5f5f5; }
.card { background:white; padding:15px; border-radius:10px; box-shadow:0 3px 8px rgba(0,0,0,0.1); margin-bottom:25px; }
table { width:100%; border-collapse:collapse; }
th, td { border:1px solid #ccc; padding:8px; font-size:14px; }
th { background:#eee; }
.pnl-green { color:green; font-weight:bold; }
.pnl-red { color:red; font-weight:bold; }
.pagination a {
    padding:8px 12px;
    margin:0 3px;
    background:#ddd;
    text-decoration:none;
    border-radius:5px;
}
.active-page { background:#333; color:white; }
</style>

</head>
<body>

<h2>My Closed Trades</h2>

<div class="card">
<h3>Filters</h3>

<form method="GET">

Symbol:
<input type="text" name="symbol" value="<?= $_GET['symbol'] ?? '' ?>">

Ticket:
<input type="text" name="ticket" value="<?= $_GET['ticket'] ?? '' ?>">

Date From:
<input type="date" name="start" value="<?= $_GET['start'] ?? '' ?>">

To:
<input type="date" name="end" value="<?= $_GET['end'] ?? '' ?>">

<button type="submit">Filter</button>
<a href="trades.php">Reset</a>

</form>
</div>

<div class="card">
<table>
<tr>
    <th>ID</th>
    <th>Ticket</th>
    <th>Symbol</th>
    <th>Type</th>
    <th>Volume</th>
    <th>Entry</th>
    <th>Exit</th>
    <th>Profit</th>
    <th>SL</th>
    <th>TP</th>
    <th>Opened</th>
    <th>Closed</th>
</tr>

<?php while($t = $trades->fetch_assoc()): ?>
<tr>
    <td><?= $t['id'] ?></td>
    <td><?= $t['ticket'] ?></td>
    <td><?= $t['symbol'] ?></td>
    <td><?= strtoupper($t['type']) ?></td>
    <td><?= $t['volume'] ?></td>
    <td><?= $t['open_price'] ?></td>
    <td><?= $t['close_price'] ?></td>

    <td class="<?= ($t['profit'] >= 0 ? 'pnl-green' : 'pnl-red') ?>">
        <?= number_format($t['profit'], 2) ?>
    </td>

    <td><?= $t['sl'] ?></td>
    <td><?= $t['tp'] ?></td>
    <td><?= $t['open_time'] ?></td>
    <td><?= $t['close_time'] ?></td>
</tr>
<?php endwhile; ?>

</table>
</div>

<!-- PAGINATION -->
<div class="card">
<h3>Pages</h3>

<?php for($i = 1; $i <= $totalPages; $i++): ?>
    <a class="<?= ($i == $page ? 'active-page' : '') ?>" href="?page=<?= $i ?>">
        <?= $i ?>
    </a>
<?php endfor; ?>

</div>

</body>
</html>
