<?php
define("FXH_PORTAL", true);
$pageTitle = "Open Trades";

// 1) Load config FIRST (session_start happens inside)
require_once __DIR__ . '/../config.php';

// 2) Load user authentication SECOND
require_once __DIR__ . '/../middleware/user_auth.php';

// 3) Load HTML header THIRD (safe now)
require_once __DIR__ . "/includes/header.php";

// 4) Load sidebar FOURTH (safe now)
require_once __DIR__ . "/includes/sidebar.php";
?>

<style>
/* ===========================================================
   PAGE WRAPPER
=========================================================== */
.fxh-page {
    margin-left: 260px;
    padding: 25px;
    transition: margin-left .25s;
}

/* When sidebar is collapsed (desktop mode) */
.fxh-sidebar.collapsed ~ .fxh-page {
    margin-left: 80px !important;
}

/* ===========================================================
   CARD WRAPPER
=========================================================== */
.fxh-card {
    background: #10151f;
    border-radius: 12px;
    border: 1px solid #1d2533;
    padding: 0;
    width: 100%;
    max-width: 1300px;
    margin: 0 auto;
}

/* ===========================================================
   TABLE WRAPPER
=========================================================== */
.fxh-table-wrap { width: 100%; overflow-x: auto; }

/* ===========================================================
   TABLE
=========================================================== */
.fx-table {
    width: 100%;
    font-size: 13px;
    color: #cfeaff;
    border-collapse: collapse;
}

.fx-table thead th {
    background: #0d1117;
    padding: 10px;
    white-space: nowrap;
    border-bottom: 1px solid #1e2736;
    font-weight: 500;
}

.fx-table td {
    padding: 8px 10px;
    border-bottom: 1px solid #1a2432;
    white-space: nowrap;
}

/* Neon hover */
.fx-table tbody tr {
    transition: background .18s ease, box-shadow .18s ease, transform .08s ease;
}
.fx-table tbody tr:hover {
    background: radial-gradient(circle at top left, #0b2436, #10151f);
    box-shadow: 0 0 18px rgba(0,234,255,0.18);
    transform: translateY(-1px);
}

/* ===========================================================
   BUTTONS
=========================================================== */
.fx-btn {
    padding: 4px 11px;
    font-size: 12px;
    border-radius: 999px;
    border: none;
    cursor: pointer;
    font-weight: 500;
    letter-spacing: 0.3px;
}

/* Close = Neon Red */
.fx-btn-close {
    background: linear-gradient(135deg,#ff3b47,#ff0066);
    color: #fff;
    box-shadow: 0 0 10px rgba(255,59,71,0.45);
}
.fx-btn-close:hover {
    background: linear-gradient(135deg,#ff5b71,#ff1f7c);
    box-shadow: 0 0 16px rgba(255,59,71,0.7);
}

/* Partial = Neon Blue */
.fx-btn-partial {
    background: linear-gradient(135deg,#008cff,#00e5ff);
    color: #fff;
    box-shadow: 0 0 10px rgba(0,197,255,0.45);
}
.fx-btn-partial:hover {
    background: linear-gradient(135deg,#21a3ff,#33f0ff);
    box-shadow: 0 0 16px rgba(0,197,255,0.75);
}

/* Profit colors */
.profit-pos { color:#3ddc91;font-weight:600; }
.profit-neg { color:#ff6767;font-weight:600; }

/* Extra row hover effect */
.fx-row {
    transition: background 0.2s ease, box-shadow 0.2s ease, transform 0.15s ease;
}
.fx-row:hover {
    background: rgba(0, 234, 255, 0.04);
    box-shadow: 0 0 12px rgba(0, 234, 255, 0.15);
    transform: translateY(-1px);
}

/* ===========================================================
   INLINE STATUS TEXT
=========================================================== */
.trade-status-msg{
    margin-left:8px;
    font-size:11px;
    font-weight:700;
    color:#00ff9c;
    opacity:0;
    transition:opacity .2s ease;
    text-shadow:0 0 8px rgba(0,255,160,.8);
}
.trade-status-msg.show{
    opacity:1;
}
</style>

<!-- ===========================================================
     PAGE CONTENT
=========================================================== -->
<div class="fxh-page">

    <h3 style="color:#86c9ff;margin-bottom:18px;">Open Trades</h3>

    <div class="fxh-card">
        <div class="fxh-table-wrap">

            <table class="fx-table">
                <thead>
                    <tr>
                        <th>Ticket</th>
                        <th>Symbol</th>
                        <th>Type</th>
                        <th>Lots</th>
                        <th>Entry</th>
                        <th>SL</th>
                        <th>TP</th>
                        <th>Profit</th>
                        <th>Swap</th>
                        <th>Commission</th>
                        <th>Open Time</th>
                        <th style="text-align:center;">Actions</th>
                    </tr>
                </thead>

                <tbody id="liveTable">
                    <tr>
                        <td colspan="12" style="text-align:center;color:#7f8ca8;">Loading trades…</td>
                    </tr>
                </tbody>

            </table>

        </div>
    </div>

</div>

<!-- ===========================================================
     SCRIPTS
=========================================================== -->

<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


<script>
/* ===========================================================
   AJAX REFRESH TABLE
=========================================================== */
function refreshTable() {
    $("#liveTable").load("open_trades_ajax.php");
}
refreshTable();
setInterval(refreshTable, 2000);


/* ===========================================================
   INLINE CLOSE TRADE — NO POPUPS
=========================================================== */
window.closeTrade = function(ticket, btn)
{
    btn.disabled = true;

    fetch("/portal/user/trade_close.php",{
        method: "POST",
        headers: { "Content-Type":"application/x-www-form-urlencoded" },
        body: "ticket=" + encodeURIComponent(ticket)
    })
    .then(r=>r.text())
    .then(resp=>{

        console.log("CLOSE RESPONSE:", resp);

        const label = btn.nextElementSibling;

        if(resp.trim()==="OK"){
            label.innerText = "TRADE CLOSED";
            label.style.color = "#00ff9c";
        } else {
            label.innerText = "FAILED";
            label.style.color = "#ff4b4b";
        }

        label.classList.add("show");

        setTimeout(()=>{
            label.classList.remove("show");
            label.innerText = "";
            btn.disabled=false;
        },2000);
    })
    .catch(err=>{
        console.error(err);

        const label = btn.nextElementSibling;
        label.innerText = "NETWORK ERROR";
        label.style.color = "#ff4b4b";
        label.classList.add("show");

        setTimeout(()=>{
            label.classList.remove("show");
            label.innerText = "";
            btn.disabled=false;
        },3000);
    });
};


/* ===========================================================
   PARTIAL CLOSE — KEEP SWEETALERT
=========================================================== */
$(document).on("click", ".fx-btn-partial", function () {

    let ticket = $(this).data("ticket");
    let vols   = prompt("Enter lots to close (ex: 0.05)");

    if(!vols || parseFloat(vols) <= 0) return;

    fetch("/portal/user/trade_partial.php",{
        method:"POST",
        headers:{ "Content-Type":"application/x-www-form-urlencoded" },
        body:"ticket="+encodeURIComponent(ticket)+"&volume="+encodeURIComponent(vols)
    })
    .then(r=>r.text())
    .then(resp=>{
        console.log("PARTIAL RESPONSE:",resp);
    })
    .catch(err=>{
        console.error("Partial close failed",err);
    });

});
</script>

<?php include __DIR__ . "/includes/footer.php"; ?>
