const WebSocket = require('ws');

const PORT = 8181;

const wss = new WebSocket.Server({ port: PORT });

console.log("✅ FX-HUNTER WS SERVER running on port " + PORT);

// Broadcast helper
function broadcast(data){
    wss.clients.forEach(c=>{
        if(c.readyState===WebSocket.OPEN){
            c.send(JSON.stringify(data));
        }
    });
}

// Simulated tick stream (for testing only)
setInterval(()=>{

   const tick = {
      type: "tick",
      symbol: ["XAUUSD","NAS100","EURUSD","US30"][Math.floor(Math.random()*4)],
      bid: (2000 + Math.random() * 500).toFixed(2),
      ask: (2000 + Math.random() * 500 + 2).toFixed(2),
      spread: (Math.random() * 3).toFixed(1),
      time: Date.now()
   };

   broadcast(tick);

},500);

// client connect log
wss.on("connection", ws=>{
    console.log("📡 Terminal connected");
});
