<?php
define("FXH_PORTAL", true);

require_once __DIR__ . "/config.php";
require_once __DIR__ . "/middleware/user_auth.php";

/* --------------------------
   GET PLAN
--------------------------- */
$plan = strtoupper($_GET['plan'] ?? "");

/* --------------------------
   VALID PLANS
--------------------------- */
$plans = [
    "BRONZE"  => ["price"=>20,  "keys"=>1,  "term"=>"1-Month"],
    "SILVER"  => ["price"=>30,  "keys"=>3,  "term"=>"1-Month"],
    "GOLD"    => ["price"=>90,  "keys"=>10, "term"=>"1-Year"],
    "DIAMOND" => ["price"=>999, "keys"=>10, "term"=>"LIFETIME"],
];

/* --------------------------
   INVALID PLAN -> BACK
--------------------------- */
if (!isset($plans[$plan])) {
    fxh_set_flash("Invalid plan selected.");
    header("Location: /portal/plans.php");
    exit;
}

$p = $plans[$plan];

/* --------------------------
   LOAD UI
--------------------------- */
require_once __DIR__ . "/user/includes/header.php";
require_once __DIR__ . "/user/includes/sidebar.php";
?>

<style>
.checkout-wrap{
    max-width:680px;
    margin:60px auto;
}

.checkout-card{
    background:rgba(10,14,22,.92);
    border-radius:20px;
    border:1px solid rgba(0,234,255,.25);
    box-shadow:0 0 26px rgba(0,234,255,.18);
    padding:34px;
}

.checkout-title{
    text-align:center;
    font-size:28px;
    font-weight:700;
    margin-bottom:14px;
}

.checkout-title span{
    color:#00ff9c;
}

.checkout-grid{
    display:grid;
    grid-template-columns:1fr 1fr;
    gap:22px;
    margin-top:26px;
}

.checkout-box{
    padding:20px;
    background:rgba(15,18,28,.85);
    border-radius:14px;
    border:1px solid rgba(0,234,255,.15);
    box-shadow: inset 0 0 12px rgba(0,234,255,.08);
    text-align:center;
}

.checkout-label{
    opacity:.8;
    font-size:13px;
}

.checkout-value{
    font-size:20px;
    font-weight:700;
    margin-top:6px;
}

.checkout-price{
    font-size:36px;
    font-weight:900;
    color:#00ff9c;
}

.checkout-pay{
    margin-top:30px;
    text-align:center;
}

/* ===============================
   CRYPTO PAY BUTTON (FA ICONS)
================================*/

.crypto-pay-wrap{
    display:flex;
    justify-content:center;
    margin-top:20px;
}

.crypto-btn{
    display:flex;
    align-items:center;
    gap:14px;
    padding:14px 36px;
    border-radius:18px;
    background:linear-gradient(135deg,#00eaff,#7a35ff);
    color:#fff;
    text-decoration:none!important;
    font-weight:700;
    letter-spacing:.4px;
    box-shadow:
        0 0 14px rgba(0,234,255,.45),
        inset 0 0 10px rgba(255,255,255,.08);
    transition:.25s ease;
}

.crypto-btn:hover{
    transform:translateY(-2px) scale(1.03);
    box-shadow:
        0 0 30px rgba(0,234,255,.85),
        inset 0 0 14px rgba(255,255,255,.15);
}

.crypto-text{
    display:flex;
    align-items:center;
    gap:8px;
    font-size:16px;
}

.crypto-icons{
    display:flex;
    align-items:center;
    gap:10px;
    font-size:18px;
}

.crypto-icons i{
    filter:drop-shadow(0 0 6px rgba(0,234,255,.8));
    transition:.2s ease;
}

.crypto-btn:hover .crypto-icons i{
    transform:scale(1.15);
}

</style>

<div class="fxh-main">

<div class="checkout-wrap">

    <div class="checkout-card">

        <div class="checkout-title">
            Checkout — <span><?= htmlspecialchars($plan) ?></span>
        </div>

        <div class="checkout-grid">

            <div class="checkout-box">
                <div class="checkout-label">PLAN</div>
                <div class="checkout-value"><?= htmlspecialchars($plan) ?></div>
            </div>

            <div class="checkout-box">
                <div class="checkout-label">PRICE</div>
                <div class="checkout-price">$<?= number_format($p["price"],2) ?></div>
            </div>

            <div class="checkout-box">
                <div class="checkout-label">TERMINALS</div>
                <div class="checkout-value"><?= intval($p["keys"]) ?></div>
            </div>

            <div class="checkout-box">
                <div class="checkout-label">VALIDITY</div>
                <div class="checkout-value"><?= htmlspecialchars($p["term"]) ?></div>
            </div>

        </div>

        <div class="checkout-pay">

            <div class="crypto-pay-wrap">

    <a href="/portal/api/start_crypto_payment.php?plan=<?= urlencode($plan) ?>" class="crypto-btn">

        <span class="crypto-text">
            <i class="fa-solid fa-credit-card"></i>
            PAY WITH CRYPTO
        </span>

        <span class="crypto-icons">
            <i class="fa-brands fa-bitcoin"></i>
            <i class="fa-brands fa-ethereum"></i>
            <i class="fa-solid fa-dollar-sign"></i>
        </span>

    </a>

</div>

        </div>

    </div>

</div>

</div>

<?php require_once __DIR__ . "/user/includes/footer.php"; ?>
