<?php
require_once '../config.php';

$data = json_decode(file_get_contents("php://input"), true);
if(!$data){ die("Missing JSON"); }

$license = $data['license'];
$account = $data['account'];
$ticket  = $data['ticket'];
$symbol  = $data['symbol'];
$type    = $data['type'];
$volume  = $data['volume'];
$open_price = $data['open_price'];
$sl      = $data['sl'];
$tp      = $data['tp'];
$profit  = $data['profit'];
$swap    = $data['swap'];
$commission = $data['commission'];
$open_time = $data['open_time'];

$stmt = $conn->prepare("
INSERT INTO fxh_positions_live 
(license_key, mt5_account, ticket, symbol, type, volume, open_price, sl, tp, profit, swap, commission, open_time)
VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)
ON DUPLICATE KEY UPDATE
 profit=VALUES(profit),
 sl=VALUES(sl),
 tp=VALUES(tp),
 updated_at=NOW()
");

$stmt->bind_param("sisssddddddsds",
    $license, $account, $ticket, $symbol, $type, $volume, $open_price,
    $sl, $tp, $profit, $swap, $commission, $open_time
);

$stmt->execute();
$stmt->close();

echo "OK";
