<?php
// ----------------------------------------------------
// HARD RULES FOR DESKTOP API
// ----------------------------------------------------
error_reporting(0);
ini_set("display_errors", 0);

header("Content-Type: application/json");

// ----------------------------------------------------
// BOOTSTRAP
// ----------------------------------------------------
require_once "../config.php";
require_once "_desktop_guard.php";

// ----------------------------------------------------
// GET USER EMAIL FROM SESSION (ACTUAL SCHEMA KEY)
// ----------------------------------------------------
$userEmail = $_SESSION["email"] ?? null;

if (!$userEmail) {
    echo json_encode([
        "success" => false,
        "error"   => "NO_EMAIL"
    ]);
    exit;
}

// ----------------------------------------------------
// FETCH LICENSES (MATCH REAL fxh_licenses SCHEMA)
// ----------------------------------------------------
$stmt = $conn->prepare("
    SELECT
        license_key,
        mt5_account,
        trade_enabled,
        is_active,
        active
    FROM fxh_licenses
    WHERE user_email = ?
");

$stmt->bind_param("s", $userEmail);
$stmt->execute();
$res = $stmt->get_result();

// ----------------------------------------------------
// BUILD RESPONSE
// ----------------------------------------------------
$licenses = [];

while ($r = $res->fetch_assoc()) {
    $licenses[] = [
        "license_key" => $r["license_key"],
        "mt5_account" => (int)$r["mt5_account"],
        "enabled"     => (
            (int)$r["trade_enabled"] === 1 &&
            (int)$r["is_active"] === 1 &&
            (int)$r["active"] === 1
        )
    ];
}

// ----------------------------------------------------
// FINAL JSON (PURE, CLEAN)
// ----------------------------------------------------
echo json_encode([
    "success"  => true,
    "licenses" => $licenses
]);
exit;
